<?php
include('../includes/session.php');
include('../includes/config.php');

header('Content-Type: application/json');

if(isset($_POST['order_id']) && !empty($_POST['order_id'])){
    $order_id = mysqli_real_escape_string($ahk_conn, $_POST['order_id']);
    
    // Check status from API
    $url = "https://" . $flexsecure_upiUrl . "/api/check_order_sts";
    $data = array("order_id" => $order_id);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    
    if($response){
        $resArray = json_decode($response, true);
        
        if($resArray && isset($resArray['result']['status'])){
            echo json_encode([
                'status' => $resArray['result']['status'],
                'amount' => $resArray['result']['amount'] ?? 0,
                'utr' => $resArray['result']['bank_txn_id'] ?? $resArray['result']['utr'] ?? ''
            ]);
        } else {
            echo json_encode(['status' => 'PENDING']);
        }
    } else {
        echo json_encode(['status' => 'ERROR']);
    }
} else {
    echo json_encode(['status' => 'INVALID_REQUEST']);
}
?>
